/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.time;

import java.util.Date;

public class TimeRange {
    private Date earliestTime;
    private Date latestTime;

    public TimeRange(Date earliest, Date latest) {
        if (earliest.after(latest)) {
            throw new IllegalArgumentException("Earliest date in time range is after the latest date");
        }
        this.earliestTime = earliest;
        this.latestTime = latest;
    }

    public TimeRange(Date earliest, long duration) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("The duration must be greater than 0; " + duration + " is not valid.");
        }
        this.earliestTime = earliest;
        this.latestTime = new Date(earliest.getTime() + duration);
    }

    public Date getEarliestTime() {
        return this.earliestTime;
    }

    public Date getLatestTime() {
        return this.latestTime;
    }

    public long getDuration() {
        return this.latestTime.getTime() - this.earliestTime.getTime() + 1L;
    }
}

